
#ifndef _1_CRYS_SEP_ATP_DES_Acceptance_h_H
#define _1_CRYS_SEP_ATP_DES_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_DES_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/********************************************************************************
* Function Name:
*  SEPQA_DES_NotIntegrated
*
* Inputs:
* IV_ptr - this parameter is the buffer of the IV or counters on mode CTR.
*                          In ECB mode this parameter has no use.
*                          In CBC and MAC modes this parameter should containe the IV values.
*                          in CTR mode this value shuld contain the init counter.
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP, 
* that executes AES not integrated test
* Algorithm:     
* 1. Allocate memory buffers
* 2. Calling the DES init function
* 3. Calling the DES Block function
* 4. Calling the Free function
* 5. Compare the result to expected result
* 6. Free allocated buffers
********************************************************************************/
CRYSError_t SEPQA_DES_NotIntegrated(CRYS_DES_Iv_t             IV_ptr,                 /* in */ 
									CRYS_DES_Key_t           *Key_ptr,                /* in */ 
									CRYS_DES_NumOfKeys_t      NumOfKeys,              /* in */ 
									CRYS_DES_EncryptMode_t    EncryptDecryptFlag,     /* in */  
									CRYS_DES_OperationMode_t  OperationMode,          /* in */     
									DxUint8_t                *DataIn_ptr,             /* in */ 
									DxUint32_t                DataInSize,             /* in */ 
									DxUint8_t                *ExpectedDataOut_ptr,        
									DxUint32_t                DataExpSize,
									DxUint32_t				  OutputLocation,
									DxUint8_t                *FailureFunctionNameOut_ptr);									


/********************************************************************************
* Function Name:
*  SEPQA_DES_Integrated
*
* Inputs:
* IV_ptr - this parameter is the buffer of the IV or counters on mode CTR.
*                          In ECB mode this parameter has no use.
*                          In CBC and MAC modes this parameter should containe the IV values.
*                          in CTR mode this value shuld contain the init counter.
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP, 
* that executes AES not integrated test
* Algorithm:     
* 1. Allocate memory buffers
* 2. Calling the DES function
* 4. Calling the Free function
* 5. Compare the result to expected result
* 6. Free allocated buffers
********************************************************************************/
CRYSError_t SEPQA_DES_Integrated(
								 CRYS_DES_Iv_t             IV_ptr,                 /* in */ 
								 CRYS_DES_Key_t           *Key_ptr,                /* in */ 
								 CRYS_DES_NumOfKeys_t      NumOfKeys,              /* in */ 
								 CRYS_DES_EncryptMode_t    EncryptDecryptFlag,     /* in */  
								 CRYS_DES_OperationMode_t  OperationMode,          /* in */     
								 DxUint8_t                *DataIn_ptr,             /* in */ 
								 DxUint32_t                DataInSize,             /* in */ 
								 DxUint8_t                *ExpectedData_ptr,        
								 DxUint32_t                DataExpSize,
								 DxUint32_t				   OutputLocation,
								 DxUint8_t                *FailureFunctionNameOut_ptr);



#ifdef __cplusplus
}
#endif

#endif



